/*
 * Structures for dealing with maps and routes
 */

#include <time.h>

/*
 * Reason mapping has been restarted
 */
enum mi_restart_reason {
  MIR_NO_REASON,
  MIR_DUP_MAC_XBAR,
  MIR_DUP_MAC_PORT
};

/*
 * map info data
 */
struct fma_map_info {
  struct lf_topo_map *current_topo_map;
  int current_topo_map_size;
  int first_mapping;	/* true when valid map has never been received */

  uint32_t mi_map_version;
  lf_mac_addr_t mi_mapper_mac_addr;
  lf_string_t mi_mapper_hostname;
  int mi_mapper_level;

  int mi_longest_route;		/* longest route from this node to another */
  int mi_most_ports;		/* most ports seen on an xbar */

  /* variables for map distribution */
  int *mi_dist_list;
  int mi_dist_cnt;
  int mi_dist_total;
  int mi_dist_global_remaining;
  int mi_dist_failed;
  int mi_map_sends_pending;
  int mi_next_map_send;
  time_t mi_dist_start_time;
  void (*mi_dist_complete_rtn)(void);

  /* some static headers we use... */
  struct lf_myri_packet_hdr topo_map_hdr;

  enum mi_restart_reason mi_rest_reason; /* reason for last restart */
  lf_mac_addr_t mi_rest_mac_addr;	/* MAC addr responsible for restart */
};

/*
 * Table containing a route to every other NIC
 */
#define FMA_MAX_NUM_ROUTES 8
#define FMA_NUM_ROUTE_INDICES FMA_ROUTE_INDEX(A.myri->num_nics, 0, 0)
#define FMA_ROUTE_INDEX(NIC, LPORT, RPORT)	\
	(((NIC) * FMA_FABRIC(A.fabric)->max_nic_ports	\
	  * FMA_FABRIC(A.fabric)->max_nic_ports * FMA_MAX_NUM_ROUTES)	\
      + ((LPORT)* FMA_FABRIC(A.fabric)->max_nic_ports * FMA_MAX_NUM_ROUTES) \
      + ((RPORT) * FMA_MAX_NUM_ROUTES))

#define FMA_ROUTE_LEN(RMT_NIC, LCL_NIC_ID, LCL_IFC, RMT_IFC, RT_NUM) \
	(FMA_NIC(RMT_NIC)->route_lens \
         [(FMA_ROUTE_INDEX(LCL_NIC_ID, LCL_IFC, RMT_IFC) + RT_NUM)])

#define FMA_ROUTE_OFFSET(I) ((I) * FMA_IFC_ROUTE_LEN)

/*
 * prototypes
 */
int fma_copy_and_load_map(struct lf_topo_map *topo_map, int topo_map_size);
void fma_load_map_struct(struct lf_topo_map *topo_map, int topo_map_size);
void fma_release_topo_map(void);
int fma_validate_map(char *why);
void fma_load_link_state(lf_topo_link_state_t *topo_link_state);
void fma_calc_all_quick_routes(void);
void fma_find_nic_indices(void);
int fma_mac_to_nic_index(lf_mac_addr_t mac);
int fma_set_all_routes(void);
int fma_set_route(struct fma_nic_info *nip, int local_port,
	struct lf_nic *nicp2, int remote_port, int rindex, int route_num);
int fma_route_topo_map(void);
void fma_start_mapping_fabric(
    void (*map_complete_rtn)(struct lf_topo_map *topo_map, int topo_map_size));
void fma_mf_cancel_mapping(void);
void fma_mf_send_map_to_fms(struct lf_topo_map *topo_map, int topo_map_size);
void fma_standalone_load_map(struct lf_topo_map *topo_map, int topo_map_size);
void fma_standalone_map_is_invalid(char *why);
struct lf_host *fma_find_host_by_max_mac_addr(lf_mac_addr_t max_mac_addr);
void fma_map_is_invalid(int use_me, char *);
int fma_check_quick_routes(void);
void fma_distribute_topo_map(void (*completion_rtn)(void));
void fma_set_mapping_level(int level);
void fma_peer_remap_request(struct fma_map_request *req,
    lf_mac_addr_t sender_mac);
void fma_set_mapper(lf_mac_addr_t mac_addr, int level);
void fma_assign_dist_targets(struct lf_fabric *fp);
void fma_dumpit(void);
void fma_cancel_map_distribution(void);
